# 機能設計書 5-next info

## 概要

本ドキュメントは、Next.jsの環境情報表示コマンド `next info` の機能設計を記述する。開発者のシステム環境情報を収集・表示するCLIコマンドであり、バグ報告時の環境情報提供を支援する。

### 本機能の処理概要

`next info` コマンドは、Next.jsのインストール情報・OS情報・Node.js情報等を収集して標準出力に表示するCLIコマンドである。

**業務上の目的・背景**：バグ報告や問題のトラブルシューティングにおいて、再現環境の情報は不可欠である。`next info` はシステム情報を一括で取得・表示し、GitHubのIssue報告に貼り付け可能な形式で出力する。これにより、問題報告の品質が向上し、メンテナーによる問題の再現・解決が効率化される。

**機能の利用シーン**：Next.jsのバグ報告時、または環境固有の問題をデバッグする際に使用する。`--verbose`オプションにより、next-swcのインストール状況やシステム依存関係の詳細診断を実行できる。

**主要な処理内容**：
1. OS情報の収集（プラットフォーム、アーキテクチャ、バージョン、メモリ、CPUコア数）
2. バイナリバージョンの取得（Node.js、npm、Yarn、pnpm）
3. パッケージバージョンの取得（next、react、react-dom、typescript、eslint-config-next）
4. Next.js設定情報の取得（output設定）
5. バージョンの古さチェック（npmレジストリからlatest/canaryタグを取得）
6. 詳細診断モード（--verbose）：next-swcのインストール・共有ライブラリ依存関係チェック

**関連システム・外部連携**：npmレジストリ（バージョン情報取得）、OS固有のバイナリ（ldd、otool、dumpbin.exe）

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 関連画面なし（CLIコンソール出力のみ） |

## 機能種別

CLIコマンド / 情報表示 / 診断

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --verbose | boolean | No | 詳細診断モードを有効化 | なし |

### 入力データソース

- CLI引数
- システムAPI（os.platform()、os.arch()等）
- npmレジストリAPI（`{registry}-/package/next/dist-tags`）
- ローカルのpackage.json（パッケージバージョン）
- next.config.js / next.config.ts

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Operating System | object | プラットフォーム・アーキテクチャ・バージョン・メモリ・CPUコア数 |
| Binaries | object | Node.js・npm・Yarn・pnpmのバージョン |
| Relevant Packages | object | next・eslint-config-next・react・react-dom・typescriptのバージョン |
| Next.js Config | object | output設定値 |
| バージョン古さ情報 | string | latest/canaryとの比較結果 |
| 詳細診断レポート（verbose） | text | next-swcインストール状況・共有ライブラリ依存関係 |

### 出力先

- 標準出力（テキスト形式の環境情報レポート）

## 処理フロー

### 処理シーケンス

```
1. 通常モード（printInfo）
   1-1. ローカルnextパッケージのバージョン取得
   1-2. next.config読み込み（PHASE_INFO）
   1-3. npmレジストリからlatest/canaryタグ取得
   1-4. バージョンの古さ判定（parseVersionInfo / getStaleness）
   1-5. OS情報収集（os APIから）
   1-6. バイナリバージョン取得（--versionで実行）
   1-7. パッケージバージョン取得
   1-8. 結果をフォーマットして出力
   1-9. 古いバージョンの場合は更新推奨メッセージを表示

2. 詳細モード（printVerboseInfo / --verbose）
   2-1. ホストシステム情報（WSL、Docker、CI検出）
   2-2. Next.jsインストール情報（通常モードと同等）
   2-3. Node.js診断レポート（process.report.getReport）
   2-4. next-swcインストールチェック（loadBindings、getTargetTriple）
   2-5. next-swc共有ライブラリ依存チェック（OS別ツール使用）
```

### フローチャート

```mermaid
flowchart TD
    A[next info 実行] --> B{--verbose?}
    B -->|No| C[printInfo]
    B -->|Yes| D[printVerboseInfo]
    C --> C1[パッケージバージョン取得]
    C1 --> C2[Next.js設定読み込み]
    C2 --> C3[npmレジストリからバージョン情報取得]
    C3 --> C4[バージョン古さ判定]
    C4 --> C5[OS/バイナリ情報収集]
    C5 --> C6[結果出力]
    D --> D1[タスク一覧を順次実行]
    D1 --> D2[ホストシステム情報]
    D2 --> D3[Next.jsインストール情報]
    D3 --> D4[Node.js診断レポート]
    D4 --> D5[next-swcインストールチェック]
    D5 --> D6[共有ライブラリ依存チェック]
    D6 --> D7[診断レポート出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | npmレジストリフェッチ失敗時 | バージョン比較をスキップし、ローカルバージョンのみ表示。警告メッセージを出力 | ネットワークエラー時 |
| BR-02 | バージョン古さ警告 | バージョンがstaleの場合、canaryでの確認を推奨するメッセージを表示 | staleness.startsWith('stale')の場合 |
| BR-03 | 詳細モードのプラットフォーム制限 | --verboseはwin32、linux、darwinのみサポート | 他のプラットフォームでは不対応メッセージ表示 |
| BR-04 | 共有ライブラリチェックのスキップ | OS固有ツール（ldd, otool等）が見つからない場合はスキップ | ツールの存在チェック失敗時 |
| BR-05 | 診断レポートの機密情報除去 | Node.js診断レポートからcwd、commandLine、host、cpus、networkInterfacesを削除 | --verbose時のNode.js診断レポート生成時 |
| BR-06 | Rspackバージョン表示 | NEXT_RSPACK環境変数設定時はnext-rspackのバージョンも表示 | process.env.NEXT_RSPACK設定時 |

### 計算ロジック

- メモリ表示: `Math.ceil(os.totalmem() / 1024 / 1024)` でMB単位に変換

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | npmレジストリへの接続失敗 | 警告表示してバージョン比較をスキップ |
| - | パッケージ未找到 | require.resolveでパッケージが見つからない | 'N/A'を返す |
| - | バイナリ実行失敗 | npm/yarn/pnpmの--version実行失敗 | 'N/A'を返す |
| - | next-swc読み込み失敗 | loadBindingsの呼び出し失敗 | エラーメッセージを出力に含める |
| - | 診断タスク例外 | verboseモードのタスクで予期しない例外 | エラーメッセージを記録しfail結果として処理 |

### リトライ仕様

なし。

## トランザクション仕様

なし。

## パフォーマンス要件

- npmレジストリへのfetchリクエストが含まれるため、ネットワーク状況に依存する
- --verboseモードはnext-swcの読み込みやOS固有ツールの実行を含むため、数秒を要する場合がある

## セキュリティ考慮事項

- Node.js診断レポートから機密情報（cwd、commandLine、host、cpus、networkInterfaces）を削除している
- 出力結果をGitHub Issueに貼り付ける際、プロジェクトパスなどが含まれていないことを確認すべき

## 備考

- getPackageVersion関数はrequireを使ってpackage.jsonを読み込むため、node_modulesに存在するパッケージのみ検出できる
- getBinaryVersionはexecFileSyncを使用し、失敗時はexecSyncにフォールバックする
- --verboseモードのタスクシステムはPlatformTaskScript型を使い、OS別のスクリプトを実行可能にしている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | NextInfoOptions型定義（14-16行目）、TaskResult型（18-24行目）、PlatformTaskScript型（28-53行目） |

**読解のコツ**: PlatformTaskScript型はTypeScriptのユニオン型を使い、少なくとも1つのプラットフォーム固有スクリプトまたはdefaultスクリプトが必要な構造になっている。

#### Step 2: 通常モード（printInfo）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | printInfo関数（96-169行目）。バージョン取得・OS情報収集・出力フォーマット |

**主要処理フロー**:
1. **97行目**: getPackageVersion('next')でローカルバージョン取得
2. **98行目**: getNextConfig()でnext.config読み込み
3. **105-113行目**: npmレジストリからdist-tagsをfetchし、parseVersionInfoで解析
4. **115行目**: getStaleness()でバージョンの古さを判定
5. **135-162行目**: 各情報をフォーマットして console.log で出力
6. **164-168行目**: バージョンが古い場合に更新推奨メッセージ表示

#### Step 3: 詳細モード（printVerboseInfo）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | printVerboseInfo関数（254-593行目）。タスクベースの診断実行 |

**主要処理フロー**:
- **276-300行目**: ホストシステム情報タスク（WSL、Docker、CI検出）
- **302-329行目**: Next.jsインストール情報タスク
- **331-365行目**: Node.js診断レポートタスク（機密情報を削除）
- **366-467行目**: next-swcインストールチェックタスク（loadBindings、tryResolve）
- **469-531行目**: 共有ライブラリ依存チェックタスク（OS別ツール使用）
- **540-577行目**: タスク実行ループと結果収集
- **579-592行目**: 診断レポートのフォーマット出力

#### Step 4: 共有ライブラリ依存チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | next-info.ts | `packages/next/src/cli/next-info.ts` | runSharedDependencyCheck関数（177-249行目） |

**主要処理フロー**:
- **189-199行目**: OS固有ツール（ldd/otool/dumpbin.exe）の存在チェック
- **211-243行目**: 各ターゲットトリプルに対して依存関係チェック実行

### プログラム呼び出し階層図

```
bin/next.ts (CLIエントリーポイント)
    │
    ├─ cli/next-info.ts::nextInfo()
    │      ├─ [通常モード] printInfo()
    │      │      ├─ getPackageVersion() [ローカル関数]
    │      │      ├─ getNextConfig() [ローカル関数]
    │      │      │      └─ server/config.ts::loadConfig()
    │      │      ├─ fetch(npmレジストリ)
    │      │      ├─ server/dev/parse-version-info.ts::parseVersionInfo()
    │      │      ├─ next-devtools/shared/version-staleness.ts::getStaleness()
    │      │      ├─ getBinaryVersion() [ローカル関数]
    │      │      └─ console.log (結果出力)
    │      │
    │      └─ [詳細モード] printVerboseInfo()
    │             ├─ タスク: ホストシステム情報
    │             │      ├─ is-wsl
    │             │      ├─ ci-info
    │             │      └─ is-docker
    │             ├─ タスク: Next.jsインストール情報
    │             ├─ タスク: Node.js診断レポート
    │             │      └─ process.report.getReport()
    │             ├─ タスク: next-swcインストール
    │             │      └─ build/swc::loadBindings()
    │             └─ タスク: 共有ライブラリ依存
    │                    └─ runSharedDependencyCheck()
    │                           └─ cross-spawn (OS固有ツール実行)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI引数 ─────────────▶ nextInfo() ──────────────────▶ 環境情報レポート (stdout)
                              │
node_modules ────────▶ getPackageVersion() ─────────▶ バージョン文字列
                              │
npmレジストリ ───────▶ fetch(dist-tags) ─────────────▶ バージョン比較結果
                              │
OS API ──────────────▶ os.platform() / os.arch() ──▶ OS情報
                              │
next.config ─────────▶ loadConfig() ────────────────▶ 設定情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next.ts | `packages/next/src/bin/next.ts` | ソース | CLIメインエントリーポイント |
| next-info.ts | `packages/next/src/cli/next-info.ts` | ソース | next infoコマンドのメイン処理 |
| config.ts | `packages/next/src/server/config.ts` | ソース | Next.js設定の読み込み |
| parse-version-info.ts | `packages/next/src/server/dev/parse-version-info.ts` | ソース | バージョン情報の解析 |
| version-staleness.ts | `packages/next/src/next-devtools/shared/version-staleness.ts` | ソース | バージョンの古さ判定 |
| get-registry.ts | `packages/next/src/lib/helpers/get-registry.ts` | ソース | npmレジストリURLの取得 |
| swc/index.ts | `packages/next/src/build/swc/index.ts` | ソース | SWCバインディングの読み込み |
